package {
	
	import away3d.core.math.Matrix3D;
	import away3d.core.math.Number3D;
	
	import caurina.transitions.Equations;
	import caurina.transitions.Tweener;
	
	import flash.events.Event;
	import flash.geom.Point;
	
	import net.saqoosha.geom.Point3D;
	
	import org.flintparticles.twoD.zones.DiscZone;
	import org.libspark.flartoolkit.away3d.FLARBaseNode;
	import org.papervision3d.materials.special.LineMaterial;

	public class FlyOutLine extends CubicBezierLine3D {
		
		private var _marker:FLARBaseNode;
		
		public function FlyOutLine(marker:FLARBaseNode) {
			super(null, null, null, null);
			this._marker = marker;
//			var n:int = this._segments.length;
//			for (var i:int = 0; i < n; i++) {
//				Line3D(this._segments[i]).size = Math.max(1, i / n * 8 - 2);
//			}
		}
		
		public function init():void {
			var zone:DiscZone = new DiscZone(new Point(0, 0), 120, 80);
			var ep:Point = zone.getLocation();
			this.p2 = new Point3D(ep.x, 100, ep.y);
			this.p3 = new Point3D(ep.x, 0, ep.y);
		}
		
//		public override function project(parent:DisplayObject3D, renderSessionData:RenderSessionData):Number {
//			this.syncToBase();
//			return super.project(parent, renderSessionData);
//		}
		
		public function startAnim():void {
			this.end = 0;
			Tweener.addTween(this, {
				end: 1,
				time: 1.3,
				transition: Equations.easeOutCubic
			});
			this.start = 0;
			Tweener.addTween(this, {
				start: 1,
				time: 1.3,
				delay: 0.3,
				transition: Equations.easeOutCubic,
				onComplete: this._dispatchComplete
			});
		}
		
		private function _dispatchComplete():void {
			this.dispatchEvent(new Event(Event.COMPLETE));
		}
		
		private var _n3:Number3D = new Number3D();
		public function syncToBase():void {
			var n:Number3D = this._n3;
			n.x = 0; 
			n.y = 0;
			n.z = -100;
			Away3DMathUtil.multiplyMatri3DNumber3D(this._marker.transform, n, n);
			this.p0.x = n.x;
			this.p0.y = n.y;
			this.p0.z = n.z;
			
			n.x = 0;
			n.y = 0;
			n.z = 100;
			Away3DMathUtil.multiplyMatri3DNumber3D(this._marker.transform, n, n);
			this.p1.x = n.x;
			this.p1.y = n.y;
			this.p1.z = n.z;
			
			this.invalidate();
		}
	}
}